/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import com.talpie.linker.audio.FrameHeader;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class FrameCodec {
    public static byte[] pack(UUID streamId, int seq, byte[] payload, boolean encrypted) {
        FrameHeader hdr = new FrameHeader();
        hdr.streamId = streamId;
        hdr.frameSeq = seq;
        hdr.payloadLength = payload.length;
        if (encrypted) {
            hdr.flags = (byte)(hdr.flags | 1);
        }
        ByteBuffer bb = ByteBuffer.allocate(32 + payload.length);
        FrameHeader.write(bb, hdr);
        bb.put(payload);
        return bb.array();
    }

    public static Decoded unpack(byte[] msg) {
        ByteBuffer bb = ByteBuffer.wrap(msg);
        FrameHeader h = FrameHeader.read(bb);
        byte[] payload = new byte[h.payloadLength];
        bb.get(payload);
        return new Decoded(h, payload);
    }

    public record Decoded(FrameHeader header, byte[] payload) {
    }
}

