/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import com.talpie.linker.ClientService;
import com.talpie.linker.StreamFrame;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class StreamOutboundSender
implements AutoCloseable,
Runnable {
    private final ClientService client;
    private final UUID streamId;
    private final BlockingQueue<byte[]> micQ;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicLong seq = new AtomicLong(0L);
    private Thread t;

    public StreamOutboundSender(ClientService client, UUID streamId, BlockingQueue<byte[]> micQ) {
        this.client = client;
        this.streamId = streamId;
        this.micQ = micQ;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.t = new Thread((Runnable)this, "StreamOutboundSender-" + String.valueOf(this.streamId));
            this.t.setDaemon(true);
            this.t.start();
        }
    }

    @Override
    public void run() {
        String sid = this.streamId.toString();
        while (this.running.get()) {
            try {
                byte[] pcm = this.micQ.take();
                long s = this.seq.incrementAndGet();
                long ts = System.nanoTime();
                StreamFrame frame = new StreamFrame(sid, s, ts, false, pcm);
                boolean ok = this.client.sendThroughStream(sid, frame);
                if (ok) continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Throwable t) {
                try {
                    this.client.getListenersHandlers().error(this, t);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    public void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        if (this.t != null) {
            this.t.interrupt();
        }
    }
}

